// Menú móvil y mejoras de UX
(function () {
  const toggle = document.querySelector('.menu-toggle');
  const nav = document.querySelector('.nav');
  if (toggle && nav) {
    toggle.addEventListener('click', () => {
      const open = nav.style.display === 'inline-flex';
      nav.style.display = open ? 'none' : 'inline-flex';
    });
  }

  // Scroll suave para anclas internas
  document.querySelectorAll('a[href^="#"]').forEach((link) => {
    link.addEventListener('click', (e) => {
      const href = link.getAttribute('href');
      if (!href || href.length < 2) return;
      const target = document.querySelector(href);
      if (target) {
        e.preventDefault();
        target.scrollIntoView({ behavior: 'smooth', block: 'start' });
      }
    });
  });

  // Lightbox simple
  const lb = document.createElement('div');
  lb.className = 'lightbox-backdrop';
  lb.innerHTML = '<img alt="" />';
  document.body.appendChild(lb);
  const lbImg = lb.querySelector('img');
  lb.addEventListener('click', () => lb.classList.remove('open'));
  document.querySelectorAll('a.g-item').forEach((a) => {
    a.addEventListener('click', (e) => {
      e.preventDefault();
      const href = a.getAttribute('href');
      if (!href) return;
      lbImg.src = href;
      lb.classList.add('open');
    });
  });

  // Before/After comparator
  document.querySelectorAll('.ba-wrap').forEach((wrap) => {
    const overlay = wrap.querySelector('.ba-overlay');
    const range = wrap.querySelector('.ba-range');
    if (!overlay || !range) return;
    const set = (val) => {
      const pct = Math.min(100, Math.max(0, Number(val)));
      overlay.style.width = pct + '%';
    };
    set(range.value);
    range.addEventListener('input', () => set(range.value));
  });
  // Formulario con fallback a envío tradicional
  const form = document.getElementById('contact-form');
  const statusEl = document.getElementById('form-status');
  const waAlt = document.getElementById('wa-alt');
  
  if (form && statusEl) {
    form.addEventListener('submit', async (e) => {
      // Intentar AJAX primero
      e.preventDefault();
      statusEl.textContent = 'Enviando...';
      statusEl.style.color = '#2a4860';
      
      const data = new FormData(form);
      try {
        const res = await fetch('contact.php', { 
          method: 'POST', 
          body: data
        });
        
        if (!res.ok) {
          throw new Error(`Error ${res.status}`);
        }
        
        const json = await res.json();
        if (json.ok) {
          statusEl.textContent = 'Enviado. Te contactaremos pronto.';
          statusEl.style.color = '#0f65d8';
          if (waAlt && json.whatsapp) {
            waAlt.setAttribute('href', json.whatsapp);
            waAlt.style.display = 'inline-flex';
          }
        } else {
          throw new Error('Error en respuesta');
        }
        form.reset();
      } catch (err) {
        console.error('Error AJAX:', err);
        statusEl.textContent = 'Enviando por método tradicional...';
        statusEl.style.color = '#d97706';
        
        // Fallback: enviar formulario tradicionalmente
        setTimeout(() => {
          form.removeAttribute('target');
          form.submit();
        }, 1000);
      }
    });
  }
})();


