<?php require_once __DIR__ . '/config.php'; require_once __DIR__ . '/lib/media.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title><?php echo esc(BRAND_FULL); ?> | <?php echo esc(GIRO); ?></title>

    <!-- SEO básico -->
    <meta name="description" content="Desabolladura y pintura a domicilio en Santiago. Rapidez y calidad profesional. Más de <?php echo esc(CARS_SERVED); ?> autos. Atención personalizada. Llama o escribe por WhatsApp." />
    <link rel="canonical" href="<?php echo esc(SITE_URL ?: ''); ?>" />

    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo esc(BRAND_FULL); ?>" />
    <meta property="og:description" content="Desabolladura y pintura a domicilio en Santiago. Rapidez, calidad y control de estándares. Más de <?php echo esc(CARS_SERVED); ?> autos." />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="<?php echo esc(SITE_URL ?: ''); ?>" />
    <meta property="og:image" content="<?php echo esc(SITE_URL ?: ''); ?>/assets/img/og.jpg" />

    <!-- Favicon (opcional) -->
    <link rel="icon" href="assets/img/logo.png" />

    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/styles.css" />
    
    <!-- Preload de imágenes críticas -->
    <?php
    $galleryDir = is_dir(__DIR__ . '/assets/img/gallery/selected') ? (__DIR__ . '/assets/img/gallery/selected') : (__DIR__ . '/assets/img/gallery');
    if (is_dir($galleryDir)) {
        $files = glob($galleryDir . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);
        if ($files && count($files) > 0) {
            usort($files, function($a, $b) { return filesize($b) <=> filesize($a); });
            // Sin GD: preload imagen original
            echo '<link rel="preload" as="image" href="assets/img/gallery/' . basename($files[0]) . '">';
        }
    }
    
    // Optimización automática al cargar la página
    if (isset($_GET['optimize']) && $_GET['optimize'] === '1') {
        $galleryDir = __DIR__ . '/assets/img/gallery';
        $debug = [];
        
        if (is_dir($galleryDir)) {
            $files = glob($galleryDir . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);
            $debug[] = "Archivos encontrados: " . count($files);
            
            // Verificar GD
            $gdAvailable = function_exists('imagecreatefromjpeg') && function_exists('imagejpeg');
            $debug[] = "GD disponible: " . ($gdAvailable ? 'Sí' : 'No');
            
            $optimizedCount = 0;
            if ($gdAvailable && function_exists('generateImageSizes')) {
                foreach ($files as $file) {
                    $debug[] = "Procesando: " . basename($file);
                    $sizes = generateImageSizes($file);
                    if (count($sizes) > 0) {
                        $optimizedCount++;
                        $debug[] = "✓ Generadas: " . implode(', ', array_keys($sizes));
                    } else {
                        $debug[] = "✗ Error procesando " . basename($file);
                    }
                }
            } else {
                $debug[] = "GD no disponible o función generateImageSizes no existe";
            }
            
            $message = "Optimización completada: $optimizedCount imágenes procesadas";
            if ($optimizedCount === 0) {
                $message .= "\n\nDebug:\n" . implode("\n", $debug);
            }
            
            // Mostrar debug en pantalla también
            echo '<div style="position:fixed;top:0;left:0;width:100%;height:100%;background:white;z-index:9999;padding:20px;font-family:monospace;overflow:auto;">';
            echo '<h2>Debug de Optimización</h2>';
            echo '<p><strong>Resultado:</strong> ' . $optimizedCount . ' imágenes procesadas</p>';
            echo '<h3>Detalles:</h3>';
            echo '<pre>' . implode("\n", $debug) . '</pre>';
            echo '<button onclick="this.parentElement.remove()" style="padding:10px 20px;background:#0f65d8;color:white;border:none;border-radius:4px;cursor:pointer;">Cerrar</button>';
            echo '</div>';
            
            echo '<script>alert("' . addslashes($message) . '");</script>';
        } else {
            echo '<script>alert("Error: No se encontró la carpeta de galería");</script>';
        }
    }
    ?>
</head>
<body>
    <header class="site-header">
        <div class="container header-inner">
            <div class="brand">
                <?php $logoPath = 'assets/img/logo.png'; ?>
                <?php if (file_exists(__DIR__ . '/' . $logoPath)) { ?>
                    <img class="logo" src="<?php echo esc($logoPath); ?>" alt="<?php echo esc(BRAND_NAME); ?>" />
                <?php } else { ?>
                    <div class="logo-circle" aria-hidden="true">V</div>
                <?php } ?>
                <div class="brand-text">
                    <strong><?php echo esc(BRAND_NAME); ?></strong>
                    <span class="sub">Desabolladura & Pintura</span>
                </div>
            </div>
            <nav class="nav" aria-label="Principal">
                <a href="#servicios">Servicios</a>
                <a href="#proceso">Proceso</a>
                <a href="#clientes">Instituciones</a>
                <a href="#testimonios">Testimonios</a>
                <a class="btn btn-outline" href="<?php echo esc(waLink('Hola Vasbal, quiero cotizar desabolladura y pintura a domicilio.')); ?>">WhatsApp</a>
            </nav>
            <button class="menu-toggle" aria-label="Abrir menú">☰</button>
        </div>
    </header>

    <section class="hero">
        <div class="container hero-inner">
            <div class="hero-copy">
                <h1><?php echo esc(BRAND_FULL); ?></h1>
                <p>
                    Rapidez y calidad superior en terreno. Atención personalizada, no somos taller masivo. Más de
                    <?php echo esc(CARS_SERVED); ?> autos y <?php echo esc(YEARS_EXPERIENCE); ?> años de experiencia.
                </p>
                <ul class="hero-bullets">
                    <li>Servicio en <?php echo esc(SERVICE_AREA); ?></li>
                    <li>Altos estándares y control de calidad</li>
                    <li>Experiencia en FACH, Gendarmería, Bomberos, Carabineros, Salud y Municipios</li>
                </ul>
                <div class="hero-cta">
                    <a class="btn btn-primary" href="<?php echo esc(waLink("Hola Vasbal, quiero cotizar un servicio de:\nPara auto modelo:\nEstoy en la Comuna de:")); ?>">Cotizar por WhatsApp</a>
                    <a class="btn btn-ghost" href="tel:<?php echo esc(PHONE_INTL); ?>">Llamar <?php echo esc(PHONE_DISPLAY); ?></a>
                </div>
                <div class="meta">
                    <span>Rut: <?php echo esc(RUT); ?></span>
                    <span>Giro: <?php echo esc(GIRO); ?></span>
                </div>
            </div>
            <div class="hero-art" aria-hidden="true">
                <?php
                // Usar la primera imagen optimizada como fondo del hero
                $galleryDir = is_dir(__DIR__ . '/assets/img/gallery/selected') ? (__DIR__ . '/assets/img/gallery/selected') : (__DIR__ . '/assets/img/gallery');
                $heroImg = '';
                if (is_dir($galleryDir)) {
                    $files = glob($galleryDir . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);
                    if ($files && count($files) > 0) {
                        // Ordenar por tamaño descendente (mejores primero) y tomar la primera
                        usort($files, function($a, $b) { return filesize($b) <=> filesize($a); });
                        $sourceFile = $files[0];
                        
                // Sin GD: usar imagen original para hero
                $heroImg = 'assets/img/gallery/' . basename($sourceFile);
                    }
                }
                if ($heroImg !== '') {
                    echo '<div class="hero-bg" style="background-image:url(' . esc($heroImg) . ');"></div>';
                }
                ?>
            </div>
        </div>
    </section>

    <section id="servicios" class="section services">
        <div class="container">
            <h2>Servicios</h2>
            <div class="cards">
                <article class="card">
                    <h3>Desabolladura</h3>
                    <p>Reparación especializada de abolladuras y golpes, respetando líneas y terminaciones.</p>
                </article>
                <article class="card">
                    <h3>Pintura</h3>
                    <p>Acabados profesionales, igualación de color y protección duradera con barnices de alto estándar.</p>
                </article>
                <article class="card">
                    <h3>Pulido</h3>
                    <p>Corrección de micro-rayas y restauración de brillo para un acabado como nuevo.</p>
                </article>
                <article class="card">
                    <h3>Simunizado</h3>
                    <p>Protección y terminación uniforme. Ideal para mejorar apariencia y durabilidad del acabado.</p>
                </article>
            </div>
            <div class="section-cta">
                <a class="btn btn-primary" href="<?php echo esc(waLink('Quiero cotizar servicio: Desabolladura/Pintura/Pulido/Simunizado')); ?>">Cotizar ahora</a>
            </div>
        </div>
    </section>

    <section id="proceso" class="section process">
        <div class="container grid-2">
            <div>
                <h2>Cómo trabajamos</h2>
                <ol class="steps">
                    <li>Envíanos fotos por WhatsApp y cuéntanos el daño.</li>
                    <li>Recibe la cotización y agenda a domicilio.</li>
                    <li>Realizamos el servicio en terreno con control de calidad.</li>
                    <li>Entrega rápida: vehículo como nuevo, exterior e interior limpio.</li>
                </ol>
                <a class="btn btn-outline" href="<?php echo esc(waLink('Hola, envío fotos para cotizar.')); ?>">Enviar fotos por WhatsApp</a>
            </div>
            <div class="process-art" aria-hidden="true"></div>
        </div>
    </section>

    <section id="clientes" class="section clients">
        <div class="container">
            <h2>Instituciones y segmentos</h2>
            <div class="logo-row">
                <span class="chip">FACH</span>
                <span class="chip">Gendarmería</span>
                <span class="chip">Bomberos</span>
                <span class="chip">Carabineros</span>
                <span class="chip">Servicios de Salud</span>
                <span class="chip">Municipios</span>
                <span class="chip">Ambulancias</span>
                <span class="chip">Ingreso Medio</span>
                <span class="chip">Mazda</span>
                <span class="chip">Subaru</span>
                <span class="chip">Honda</span>
            </div>
            <p class="note">Más de <?php echo esc(CARS_SERVED); ?> autos trabajados con altos estándares.</p>
        </div>
    </section>

    <section id="galeria" class="section gallery">
        <div class="container">
            <h2>Trabajos recientes</h2>
            <div class="gallery-grid">
                <?php
                $dir = is_dir(__DIR__ . '/assets/img/gallery/selected') ? (__DIR__ . '/assets/img/gallery/selected') : (__DIR__ . '/assets/img/gallery');
                $imgs = [];
                if (is_dir($dir)) {
                    $imgs = glob($dir . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);
                    // Ordenar por tamaño descendente (mejores primero)
                    usort($imgs, function($a, $b) { return filesize($b) <=> filesize($a); });
                    // Limitar a 9 para carga rápida
                    if (count($imgs) > 9) { $imgs = array_slice($imgs, 0, 9); }
                }
                
                foreach ($imgs as $path) {
                    // Sin GD: usar imágenes originales con lazy loading
                    $thumbSrc = 'assets/img/gallery/' . basename($path);
                    $lightboxSrc = 'assets/img/gallery/' . basename($path);
                    
                    echo '<a href="' . esc($lightboxSrc) . '" class="g-item" data-lightbox="gal">';
                    echo '<img loading="lazy" src="' . esc($thumbSrc) . '" alt="Trabajo Vasbal"/>';
                    echo '</a>';
                }
                if (empty($imgs)) {
                    echo '<p class="note">Pronto subiremos ejemplos. Puedes solicitar referencias por WhatsApp.</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <section id="comparador" class="section before-after">
        <div class="container">
            <h2>Antes y Después</h2>
            <div class="ba-grid">
                <?php
                // Versión simplificada del comparador
                $gdir = is_dir(__DIR__ . '/assets/img/gallery/selected') ? (__DIR__ . '/assets/img/gallery/selected') : (__DIR__ . '/assets/img/gallery');
                $pairs = [];
                
                if (is_dir($gdir)) {
                    $files = glob($gdir . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);
                    // Ordenar por tamaño descendente (mejores primero)
                    usort($files, function($a, $b) { return filesize($b) <=> filesize($a); });
                    
                    // Crear pares simples: tomar las primeras 8 imágenes y emparejarlas
                    $pairs = [];
                    for ($i = 0; $i < min(8, count($files)); $i += 2) {
                        if (isset($files[$i + 1])) {
                            $pairs[] = [$files[$i], $files[$i + 1]];
                        }
                    }
                    
                    // Limitar a 4 pares
                    if (count($pairs) > 4) { 
                        $pairs = array_slice($pairs, 0, 4); 
                    }
                }
                
                foreach ($pairs as $pair) {
                    $beforePath = $pair[0];
                    $afterPath = $pair[1];
                    
                    // Sin GD: usar imágenes originales
                    $beforeSrc = 'assets/img/gallery/' . basename($beforePath);
                    $afterSrc = 'assets/img/gallery/' . basename($afterPath);
                    
                    echo '<div class="ba-item">';
                    echo   '<div class="ba-wrap" data-before="' . esc($beforeSrc) . '" data-after="' . esc($afterSrc) . '">';
                    echo     '<img class="ba-after" src="' . esc($afterSrc) . '" alt="Después" loading="lazy" />';
                    echo     '<div class="ba-overlay">';
                    echo       '<img class="ba-before" src="' . esc($beforeSrc) . '" alt="Antes" loading="lazy" />';
                    echo     '</div>';
                    echo     '<input type="range" class="ba-range" min="0" max="100" value="50" aria-label="Comparador" />';
                    echo   '</div>';
                    echo '</div>';
                }
                
                if (empty($pairs)) {
                    echo '<p class="note">Agrega al menos 2 fotos en la galería para ver el comparador.</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <section id="testimonios" class="section testimonials">
        <div class="container">
            <h2>Testimonios</h2>
            <div class="testimonial-grid">
                <blockquote>“Me encantó el trabajo, por la rapidez y excelente calidad. No pensé que siendo tan rápido el resultado sería así.”</blockquote>
                <blockquote>“Estoy impactado por el nivel del choque que tenía mi auto y cómo quedó con Vasbal.”</blockquote>
                <blockquote>“Fantástico trabajo y poco tiempo. Sin detalles y limpio.”</blockquote>
                <blockquote>“Excelente trabajo, como nuevo, e incluso el auto fue entregado limpio por dentro.”</blockquote>
                <blockquote>“El auto fue entregado como si nunca hubiese sido chocado y por dentro como nuevo.”</blockquote>
            </div>
        </div>
    </section>

    <section class="section usp">
        <div class="container grid-3">
            <div class="usp-item">
                <h3>Rapidez</h3>
                <p>Agendamos y ejecutamos a domicilio con eficiencia, manteniendo la excelencia.</p>
            </div>
            <div class="usp-item">
                <h3>Personalizado</h3>
                <p>No somos taller masivo: dedicación por vehículo y control de calidad.</p>
            </div>
            <div class="usp-item">
                <h3>Experiencia</h3>
                <p><?php echo esc(YEARS_EXPERIENCE); ?> años, respaldo en instituciones estatales y municipales.</p>
            </div>
        </div>
    </section>

    <section class="section cta">
        <div class="container">
            <h2>¿Listo para cotizar?</h2>
            <p>Atendemos en <?php echo esc(SERVICE_AREA); ?>. Respuesta rápida por WhatsApp.</p>
            <div class="section-cta">
                <a class="btn btn-primary" href="<?php echo esc(waLink('Hola Vasbal, quiero cotizar.')); ?>">Escribir por WhatsApp</a>
                <a class="btn btn-ghost" href="tel:<?php echo esc(PHONE_INTL); ?>">Llamar <?php echo esc(PHONE_DISPLAY); ?></a>
            </div>
        </div>
    </section>

    <section id="cotizar" class="section form-section">
        <div class="container">
            <h2>Cotiza con fotos</h2>
            <p class="note">Envíanos tus datos y fotos del daño. Te responderemos por correo o WhatsApp.</p>
            <form id="contact-form" class="form" action="contact.php" method="post" enctype="multipart/form-data" target="_blank">
                <div class="form-grid">
                    <label class="field">
                        <span>Nombre *</span>
                        <input type="text" name="name" required placeholder="Tu nombre" />
                    </label>
                    <label class="field">
                        <span>Teléfono</span>
                        <input type="tel" name="phone" placeholder="Ej: +56 9 ..." />
                    </label>
                    <label class="field">
                        <span>Email</span>
                        <input type="email" name="email" placeholder="tu@correo.com" />
                    </label>
                    <label class="field full">
                        <span>Mensaje</span>
                        <textarea name="message" rows="4" placeholder="Describe el daño y tu disponibilidad"></textarea>
                    </label>
                    <label class="field full">
                        <span>Fotos (JPG/PNG/WebP, hasta 6MB c/u)</span>
                        <input type="file" name="photos[]" accept="image/jpeg,image/png,image/webp" multiple />
                    </label>
                </div>
                <div class="form-actions">
                    <button class="btn btn-primary" type="submit">Enviar solicitud</button>
                    <a class="btn btn-outline" href="#" id="wa-alt" rel="nofollow noopener">WhatsApp alterno</a>
                </div>
                <div id="form-status" class="form-status" role="status" aria-live="polite"></div>
            </form>
        </div>
    </section>

    <footer class="site-footer">
        <div class="container footer-inner">
            <div class="footer-brand">
                <div class="logo-circle sm" aria-hidden="true">V</div>
                <div>
                    <strong><?php echo esc(BRAND_NAME); ?></strong>
                    <div class="small">Dueños: <?php echo esc(OWNER_1); ?> &amp; <?php echo esc(OWNER_2); ?></div>
                </div>
            </div>
            <div class="footer-meta">
                <div>Rut: <?php echo esc(RUT); ?></div>
                <div>Giro: <?php echo esc(GIRO); ?></div>
                <div>Atendemos: <?php echo esc(SERVICE_AREA); ?></div>
            </div>
            <div class="footer-cta">
                <a class="btn btn-outline" href="<?php echo esc(waLink('Hola, vengo de la web y quiero cotizar.')); ?>">WhatsApp</a>
                <a class="btn btn-ghost" href="tel:<?php echo esc(PHONE_INTL); ?>">Llamar</a>
            </div>
        </div>
        <div class="container legal small">
            <span>© <?php echo date('Y'); ?> <?php echo esc(BRAND_NAME); ?>. Todos los derechos reservados.</span>
        </div>
    </footer>

    <!-- Botones flotantes -->
    <a class="fab whatsapp" href="<?php echo esc(waLink('Hola Vasbal, necesito una cotización.')); ?>" aria-label="WhatsApp">WA</a>
    <a class="fab phone" href="tel:<?php echo esc(PHONE_INTL); ?>" aria-label="Llamar">📞</a>

    <script src="assets/js/main.js"></script>
</body>
</html>


