<?php
// Optimizador web de imágenes
require_once __DIR__ . '/lib/media.php';

header('Content-Type: text/html; charset=UTF-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Optimizador de Imágenes - Vasbal</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f9ff; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        .success { color: #0f65d8; }
        .error { color: #dc2626; }
        .info { color: #577189; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 4px; overflow-x: auto; }
        button { background: #0f65d8; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🚀 Optimizador de Imágenes</h1>
        
        <?php
        if ($_POST['optimize'] ?? false) {
            echo "<h2>Procesando imágenes...</h2>";
            
            // Verificar que las funciones existan
            if (!function_exists('generateImageSizes')) {
                echo "<div class='error'>";
                echo "<p>Error: La función generateImageSizes no está disponible.</p>";
                echo "<p>Verifica que lib/media.php se esté cargando correctamente.</p>";
                echo "</div>";
            } else {
                $galleryDir = __DIR__ . '/assets/img/gallery';
                $optimizedCount = 0;
                $errors = [];
                
                echo "<div class='info'>";
                echo "<p>Buscando imágenes en: <code>$galleryDir</code></p>";
                echo "<p>Directorio existe: " . (is_dir($galleryDir) ? 'Sí' : 'No') . "</p>";
                echo "</div>";
                
                if (is_dir($galleryDir)) {
                    $files = glob($galleryDir . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);
                    
                    echo "<div class='info'>";
                    echo "<p>Archivos encontrados: " . count($files) . "</p>";
                    echo "</div>";
                    
                    echo "<pre>";
                    foreach ($files as $file) {
                        echo "Procesando: " . basename($file) . "\n";
                        echo "  Archivo existe: " . (file_exists($file) ? 'Sí' : 'No') . "\n";
                        echo "  Tamaño: " . (file_exists($file) ? filesize($file) . ' bytes' : 'N/A') . "\n";
                        
                        if (file_exists($file)) {
                            // Generar versiones optimizadas
                            $sizes = generateImageSizes($file);
                            
                            if (count($sizes) > 0) {
                                $optimizedCount++;
                                echo "  ✓ Generadas: " . implode(', ', array_keys($sizes)) . "\n";
                            } else {
                                $errors[] = basename($file);
                                echo "  ✗ Error procesando\n";
                            }
                        } else {
                            $errors[] = basename($file);
                            echo "  ✗ Archivo no encontrado\n";
                        }
                        echo "\n";
                    }
                    echo "</pre>";
                    
                    echo "<div class='success'>";
                    echo "<h3>✅ Optimización completada</h3>";
                    echo "<p><strong>$optimizedCount archivos procesados</strong></p>";
                    echo "<p>Las imágenes optimizadas se guardan en: <code>assets/img/gallery/optimized/</code></p>";
                    
                    if (!empty($errors)) {
                        echo "<div class='error'>";
                        echo "<h4>⚠️ Errores:</h4>";
                        echo "<p>Archivos con problemas: " . implode(', ', $errors) . "</p>";
                        echo "</div>";
                    }
                    echo "</div>";
                    
                } else {
                    echo "<div class='error'>";
                    echo "<p>No se encontró la carpeta de galería: $galleryDir</p>";
                    echo "<p>Verifica que la carpeta exista y tenga permisos de lectura.</p>";
                    echo "</div>";
                }
            }
        } else {
            ?>
            <div class="info">
                <h3>¿Qué hace este optimizador?</h3>
                <ul>
                    <li><strong>Redimensiona</strong> imágenes a múltiples tamaños (thumb, medium, large)</li>
                    <li><strong>Comprime</strong> archivos manteniendo calidad visual</li>
                    <li><strong>Mejora</strong> velocidad de carga del sitio web</li>
                    <li><strong>Genera</strong> versiones optimizadas en <code>assets/img/gallery/optimized/</code></li>
                </ul>
                
                <h3>Tamaños generados:</h3>
                <ul>
                    <li><strong>Thumbnail:</strong> 300x200px (para galería)</li>
                    <li><strong>Medium:</strong> 600x400px (para comparadores)</li>
                    <li><strong>Large:</strong> 1200x800px (para hero y lightbox)</li>
                </ul>
            </div>
            
            <form method="post">
                <button type="submit" name="optimize" value="1">🚀 Optimizar Imágenes</button>
            </form>
            <?php
        }
        ?>
        
        <hr>
        <p><a href="index.php">← Volver al sitio</a></p>
    </div>
</body>
</html>
