<?php
// Script para optimizar todas las imágenes existentes
require_once __DIR__ . '/lib/media.php';

echo "Optimizando imágenes...\n";

$galleryDir = __DIR__ . '/assets/img/gallery';
$optimizedCount = 0;

if (is_dir($galleryDir)) {
    $files = glob($galleryDir . '/*.{jpg,jpeg,png,webp}', GLOB_BRACE);
    
    foreach ($files as $file) {
        echo "Procesando: " . basename($file) . "\n";
        
        // Generar versiones optimizadas
        $sizes = generateImageSizes($file);
        
        if (count($sizes) > 0) {
            $optimizedCount++;
            echo "  ✓ Generadas: " . implode(', ', array_keys($sizes)) . "\n";
        } else {
            echo "  ✗ Error procesando\n";
        }
    }
}

echo "\nOptimización completada: $optimizedCount archivos procesados\n";
echo "Las imágenes optimizadas se guardan en: assets/img/gallery/optimized/\n";
?>
