<?php
// Servir imágenes de forma segura
$file = $_GET['file'] ?? '';
if (empty($file)) {
    http_response_code(404);
    exit('Archivo no encontrado');
}

// Validar que el archivo esté en la carpeta uploads
$filePath = __DIR__ . '/' . basename($file);
if (!file_exists($filePath) || !is_file($filePath)) {
    http_response_code(404);
    exit('Archivo no encontrado');
}

// Validar extensión
$ext = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
if (!in_array($ext, ['jpg', 'jpeg', 'png', 'webp'])) {
    http_response_code(403);
    exit('Tipo de archivo no permitido');
}

// Servir el archivo
$mime = mime_content_type($filePath) ?: 'application/octet-stream';
header('Content-Type: ' . $mime);
header('Content-Length: ' . filesize($filePath));
header('Content-Disposition: inline; filename="' . basename($file) . '"');
readfile($filePath);
?>
